Imports System.Collections
Imports System.Drawing
'
' Egzemplarze tej klasy s obiektami kompozytowymi zawierajcymi
' obiekty klasy DocumentElement.
'
Public MustInherit Class DocumentContainer
    Inherits DocumentElement
    ' Kolekcja obiektw potomnych wzgldem tego obiektu.
    Private children As New ArrayList()

    ' Zmienna myFont reprezentuje czcionk zwizan z danym obiektem. Jeli zmienna czcionki
    ' ma warto Nothing, czcionka tego obiektu zostanie odziedziczona za porednictwem
    ' hierarchii zawierania, czyli porednio lub bezporednio po ktrym z obiektw kontenerw.
    Private myFont As Font

    Private myParent As DocumentContainer ' this object's container

    '
    ' Kolekcja obiektw potomnych wzgldem tego obiektu.
    '
    Default Public ReadOnly Property Item(ByVal index As Integer) As DocumentElement
        Get
            Return CType(children(index), DocumentElement)
        End Get
    End Property

    '
    ' Powoduje, e wskazany egzemplarz klasy DocumentElement staje si potomkiem tego obiektu.
    '
    Public Sub Add(ByVal child As DocumentElement)
        SyncLock child
            children.Add(child)
            If TypeOf child Is DocumentContainer Then
                CType(child, DocumentContainer).Parent = Me
            End If
        End SyncLock
    End Sub  ' Add(DocumentElement)

    '
    ' Powoduje, e wskazany egzemplarz klasy DocumentElement NIE jest potomkiem tego obiektu.
    '
    Public Sub Remove(ByVal child As DocumentElement)
        SyncLock child
            If TypeOf child Is DocumentContainer Then
                If Me Is CType(child, DocumentContainer).Parent Then
                    CType(child, DocumentContainer).Parent = Nothing
                End If
            End If
            children.Remove(child)
        End SyncLock
    End Sub ' Remove(DocumentElement)

    '
    ' Obiekt macierzysty wzgldem tego obiektu lub warto Nothing, jeli taki obiekt macierzysty nie istnieje.
    '
    Public Property Parent() As DocumentContainer
        Get
            Return myParent
        End Get
        Set(ByVal value As DocumentContainer)
            myParent = value
        End Set
    End Property

    '
    ' Reprezentuje egzemplarz klasy Font zwizany z danym obiektem. Jeli temu obiektowi nie przypisano
    ' adnego egzemplarza klasy Font (adnej czcionki), waciwo zwraca egzemplarz klasy Font zwizany z
    ' obiektem macierzystym tego obiektu. Jeli take obiektowi macierzystemu nie przypisano adnego obiektu,
    ' waciwo Font zwraca warto Nothing.
    '
    Public Property Font() As Font
        Get
            If myFont IsNot Nothing Then
                Return myFont
            ElseIf Parent IsNot Nothing Then
                Return Parent.Font
            Else
                Return Nothing
            End If
        End Get
        Set(ByVal value As Font)
            Me.myFont = value
        End Set
    End Property

    '...

End Class 'DocumentContainer
